﻿using log4net;
using System;
using System.Threading.Tasks;
using VA.PPMS.IWS.BlobService.Interface;
using VA.PPMS.IWS.Common;
using VA.PPMS.IWS.OrchestrationService.Interface;
using VA.PPMS.IWS.QueueService.Interface;
using VA.PPMS.ProviderData;

namespace VA.PPMS.IWS.OrchestrationService
{
    public class OrchestrationService : IOrchestrationService
    {
        private readonly ILog _logger;
        private readonly IBlobService _blobService;
        private readonly IQueueService _queueService;

        public OrchestrationService(ILog logger, IBlobService blobService, IQueueService queueService)
        {
            _logger = logger;
            _blobService = blobService;
            _queueService = queueService;
        }

        public async Task StartProcessingAsync(DasMessage message, Providers providers)
        {
            _logger.Info($"@@@@ INFO - Start Main Orchestration Service for TransactionId: {message.TransactionId} @@@@");

            try
            {
                var ableToSave = await _blobService.PutBlobAsync(message.ToString(), providers);

                if (!ableToSave)
                {
                    _logger.Error($"@@@@ ERROR - Unable to store Provider Profile for TransactionId {message.TransactionId} data in Blob Storage @@@@");
                    throw new PpmsServiceException($"Unable to store Provider data for TransactionId: {message.TransactionId} into Blob Storage");
                }

                await _queueService.PutDasQueueAsync(message);

                _logger.Info($"@@@@ INFO - End Main Orchestration Service for TransactionId: {message.TransactionId} @@@@");
            }
            catch (Exception ex)
            {
                _logger.Error($"@@@@ ERROR - There was a problem with the Main Orchestration Service for TransactionId {message.TransactionId}.", ex);
                throw new PpmsServiceException($"There was a problem with the Main Orchestration Service for TransactionId { message.TransactionId}.", ex);
            }
        }
    }
}